/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.service.serviceaction;

import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.service.serviceaction.ServiceActionException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.UUIDFactory;
import java.util.Map;

public abstract class ServiceAction
implements Persistable {
    private static final String TRACE_MASKT = "XRVF023T";
    private static final String TRACE_MASKF = "XRVF023F";
    private static final String TRACE_MASKD = "XRVF023D";
    private String uniqueKey = null;
    protected boolean delayed = false;

    public ServiceAction() {
        Trace.trace(TRACE_MASKT, "<> ServiceAction default ctor");
        this.uniqueKey = UUIDFactory.generate().toString();
    }

    public ServiceAction(PersistentData persistentData) throws ServiceActionException {
        PersistentDataImpl persistentDataImpl = (PersistentDataImpl)persistentData;
        Trace.trace(TRACE_MASKT, "-> ServiceAction ctor from PersistentData");
        Trace.trace(TRACE_MASKT, "\t\t\t-uniqueKey=" + persistentDataImpl.uniqueKey);
        Trace.trace(TRACE_MASKT, "\t\t\t-delayed=" + persistentDataImpl.delayed);
        this.uniqueKey = persistentDataImpl.uniqueKey;
        this.delayed = persistentDataImpl.delayed;
        Trace.trace(TRACE_MASKT, "<- ServiceAction ctor from PersistentData");
    }

    public PersistentData getPersistentData() {
        Trace.trace(TRACE_MASKT, "<> ServiceAction.getPersistentData");
        PersistentDataImpl persistentData = new PersistentDataImpl();
        persistentData.uniqueKey = this.uniqueKey;
        persistentData.delayed = this.delayed;
        Trace.trace(TRACE_MASKF, "\t\tService.getPersistentData - persistentData.uniqueKey=" + persistentData.uniqueKey);
        Trace.trace(TRACE_MASKF, "\t\tService.getPersistentData - delayed=" + persistentData.delayed);
        return persistentData;
    }

    public final String getUniqueKey() {
        Trace.trace(TRACE_MASKT, "<> ServiceAction.getUniqueKey [" + this.uniqueKey + "]");
        return this.uniqueKey;
    }

    public abstract void start(Map var1) throws ServiceActionException;

    public void setDelayed(boolean delayed) {
        this.delayed = delayed;
    }

    public boolean isDelayed() {
        return this.delayed;
    }

    public String toString() {
        return new String("ServiceAction[uniqueKey[" + this.uniqueKey + "],delayed[" + this.delayed + "],super[" + super.toString() + "]]");
    }

    public static class PersistentDataImpl
    implements PersistentData {
        public String uniqueKey;
        public boolean delayed;
        static final long serialVersionUID = -1L;
    }
}

